'use strict';

/* --------------------------------------------------------------
 jquery_extensions.js 2016-06-22
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

(function () {

    'use strict';

    /**
     * Add ":attr" pseudo selector.
     *
     * This selector enables jQuery to use regular expressions for attribute name matching. Although useful,
     * the engine will remove all dependencies to jQuery and thus it must be moved into an external library
     * or file.
     */

    if ($.expr.pseudos.attr === undefined) {
        $.expr.pseudos.attr = $.expr.createPseudo(function (selector) {
            var regexp = new RegExp(selector);
            return function (elem) {
                for (var i = 0; i < elem.attributes.length; i++) {
                    var attr = elem.attributes[i];
                    if (regexp.test(attr.name)) {
                        return true;
                    }
                }
                return false;
            };
        });
    }
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
